CREATE TABLE T_PATIENT_PAT
(PAT_ID         INT IDENTITY PRIMARY KEY,
 PAT_TITRE      CHAR(6),
 PAT_NOM        CHAR(32) NOT NULL,
 PAT_PRENOM     VARCHAR(25),
 PAT_NS_SEXE    CHAR(1) CHECK (PAT_NS_SEXE IN ('1', '2')),
 PAT_NS_AN      CHAR(2) CHECK (CAST(PAT_NS_AN AS INT) BETWEEN 0 AND 99),
 PAT_NS_MOIS    CHAR(2) CHECK (CAST(PAT_NS_MOIS AS INT) BETWEEN 1 AND 12),
 PAT_NS_CMN     CHAR(2) CHECK (CAST(PAT_NS_CMN AS INT) BETWEEN 1 AND 99999),
 PAT_NS_RANG    CHAR(3) CHECK (CAST(PAT_NS_RANG AS INT) BETWEEN 1 AND 999),
 CONSTRAINT CK_NSC CHECK ((     PAT_NS_SEXE IS NULL 
                            AND PAT_NS_AN IS NULL
                            AND PAT_NS_MOIS IS NULL 
							AND PAT_NS_CMN IS NULL
                            AND PAT_NS_RANG IS NULL)
                           OR ( PAT_NS_SEXE IS NOT NULL 
						    AND PAT_NS_AN IS NOT NULL
                            AND PAT_NS_MOIS IS NOT NULL 
							AND PAT_NS_CMN IS NOT NULL
                            AND PAT_NS_RANG IS NOT NULL)));